﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" AutoEventWireup="false"%>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Microsoft.Extensions.DependencyInjection" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.SrodkiTrwale" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
  <HEAD>
		<title>Wartości i umorzenia środków trwałych</title>
		
		<meta name="GENERATOR" Content="Microsoft Visual Studio 7.0">
		<meta name="CODE_LANGUAGE" Content="C#">
		<meta name="vs_defaultClientScript" content="JavaScript">
		<meta name="vs_targetSchema" content="http://schemas.microsoft.com/intellisense/ie5">
		<script runat="server">
			void Grid1_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
				SrodekTrwalyBaseHistoria sh = (SrodekTrwalyBaseHistoria)args.Row;
				SrodekTrwalyBase s = sh.Srodek;
				if (s.DataRejestracji == Date.Empty || s.DataRejestracji > p.Aktualnosc) {
					args.VisibleRow = false;
					return;
				}

				int idx = Grid1.Columns.IndexOf(colOdpisyP);

				for (int m = 1; m <= okres.Months; m++)
				{
					FromTo ft = okres.From.AddMonths(m - 1).ToYearMonth().ToFromTo();
					Grid1.Columns[++idx].EditValue = s.OdpisyBilansoweByFromTo(ft).Value;
					if (!prm.TylkoWartosciBilansowe)
					{
						Grid1.Columns[++idx].EditValue = s.OdpisyPodatkoweByFromTo(ft).Value;
					}
				}
			}

			FromTo GetFromTo(Date aktualnosc, int month) {
				FromTo ft = new YearMonth(aktualnosc.Year, month).ToFromTo();
				if (ft.From > aktualnosc)
					return FromTo.Empty;
				if (ft.To > aktualnosc)
					ft = new FromTo(ft.From, aktualnosc);
				return ft;
			}

			SrodkiTrwale.Params p = null;

			#region TylkoWartosciBilansowePrm

			TylkoWartosciBilansowePrm prm = null;

			[Context]
			public TylkoWartosciBilansowePrm Prm
			{ set { prm = value; } }


			#endregion

			bool UwzględniajKontekstOkresuObrach = false;
			FromTo okres = FromTo.Empty;			
			
			
			
      void WartosciSrodkowTrwalych_OnLoad(Object sender, EventArgs args)
	  {
				p = (SrodkiTrwale.Params)DataContext1.Get(typeof(SrodkiTrwale.Params));

				Date refDate = SrodekTrwalyBase.GetData01(p.Session, p.Aktualnosc);
				if (refDate == Date.Empty)
					throw new ApplicationException(String.Format("Brak okresu obrachunkowego dla obliczeń wartości środka z datą {0}", p.Aktualnosc));
				if (p.Aktualnosc <= refDate)
					throw new ApplicationException("Data aktualności nie zawiera się w zakresie dat okresów obrachunkowych.");
		  
				ReportHeader1.Title = "Wartości i umorzenia środków trwałych" + p.GetReportParametersDescription();
				UwzględniajKontekstOkresuObrach = SrodkiTrwaleModule.GetInstance(p).Config.Ogólne.UwzględniajKontekstOkresuObrach;
	
				if (!UwzględniajKontekstOkresuObrach)
					okres = new FromTo(new Date(p.Aktualnosc.Year, 1, 1), new Date(p.Aktualnosc.Year, 12, 31));
				else {
					var oos = p.Session.GetService(typeof(IOkresObrachunkowyService)) as IOkresObrachunkowyService;
					if (oos != null)
						okres = oos.OkresWgDaty(p.Aktualnosc);
				}

				String okresPoczatekStr = okres.From.ToString("dd.MM.yy");
				colWartosc01B.Caption = String.Format("Wartość|({0})(B)", okresPoczatekStr);
				colWartosc01P.Caption = String.Format("Wartość|({0})(P)", okresPoczatekStr);
				colOdpisy01B.Caption = String.Format("Umorzenie|({0})(B)", okresPoczatekStr);
				colOdpisy01P.Caption = String.Format("Umorzenie|({0})(P)", okresPoczatekStr);
		  
				for (int m = 1; m <= okres.Months; m++)
				{
					GridColumn col = new GridColumn();
					col.ID = string.Format("colUmorzenieB{0:D2}", m);
					col.Caption = string.Format("{0:D2} Umorzenie(B)", m);
					col.Format = "{0:n}";
					col.Align = HorizontalAlign.Right;
					col.Total = Total.Sum;
					Grid1.Columns.Add(col);

					if (!prm.TylkoWartosciBilansowe)
					{
						col = new GridColumn();
						col.ID = string.Format("colUmorzenieP{0:D2}", m);
						col.Caption = string.Format("{0:D2} Umorzenie(P)", m);
						col.Format = "{0:n}";
						col.Align = HorizontalAlign.Right;
						col.Total = Total.Sum;
						Grid1.Columns.Add(col);
					}
				}				

		if (prm.TylkoWartosciBilansowe)
		{
			Grid1.RowsInRow = 2;

			cmPodatkowaStawka.Visible = false;
			cmPodatkowaWspolczynnik.Visible = false;

			colNumerInwentarzowy.Width=0; 
			colNumerInwentarzowy.ColSpan=1;
			colNazwa.Width=0;
			colNazwa.ColSpan=3;
			colNazwa.RowSpan=1;
			colUzytkowanie.Width=11;
			colDataLikwidacji.Width=11;
			colWartosc01P.Visible = false;
			colOdpisy01P.Visible = false;
			colZwWartosciP.Visible = false;
			colZwOdpisowP.Visible = false;
			colZmWartosciP.Visible = false;
			colZmOdpisowP.Visible = false;
			colWartoscP.Visible = false;
			colOdpisyP.Visible = false;
		}
		  
		  //
		  // dodanie uzupełniających kolumn, żeby poprawnie rysował się prawy margines
		  //

		for (int extraColumns = (okres.Months % 2) * (prm.TylkoWartosciBilansowe ? 1 : 2); extraColumns > 0; --extraColumns)
		{
			GridColumn col = new GridColumn();
			col.Caption = string.Empty;
			Grid1.Columns.Add(col);
		}
				
      }
		</script>
</HEAD>
	<body>
		<form id="WartosciSrodkowTrwalych" method="post" runat="server" onload="WartosciSrodkowTrwalych_OnLoad">
			<ea:DataContext id="DataContext1" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business"
				Landscape="True" BottomMargin="10" LeftMargin="10" RightMargin="10" 
        TopMargin="10" ></ea:DataContext><BR>
			<cc1:ReportHeader id="ReportHeader1" runat="server" title="Wartości i umorzenia środków trwałych  | Aktualność: {2} | Typ: {0} | Stan: {1} | Miejsce użytkowania: {3}"></cc1:ReportHeader><BR>
			<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.SrodkiTrwale.SrodekTrwalyBaseHistoria,Soneta.Ksiega"
				OnBeforeRow="Grid1_BeforeRow"
				LinkedRows="History" ShowGroupSum="True" GroupData0="KRST.GrupaSymbol"
				GroupLine="Grupa: {0}" Sort="KRST.GrupaSymbol,NumerInwentarzowy" RowsInRow="4">
<Columns>
<ea:GridColumn Width="40" ColSpan="2" DataMember="Srodek.NumerInwentarzowy" EncodeHTML="true" Total="Info" Caption="Nr inwentarzowy" ID="colNumerInwentarzowy" runat="server"></ea:GridColumn>
<ea:GridColumn Width="40" ColSpan="2" RowSpan="2" DataMember="Srodek.Nazwa" Caption="Nazwa" EncodeHTML="true" ID="colNazwa" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Center" DataMember="Srodek.DataRozpoczeciaUzytkowania" Caption="Rozpoczęcie użytkowania" ID="colUzytkowanie" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Center" DataMember="Srodek.DataLikwidacji" Caption="Likwidacja" ID="colDataLikwidacji" runat="server"></ea:GridColumn>
<ea:GridColumn Width="7" Align="Center" DataMember="Bilansowa.Stawka" Caption="Stawka (B)" runat="server"></ea:GridColumn>
<ea:GridColumn Width="7" Align="Center" DataMember="Podatkowa.Stawka" Caption="Stawka (P)" ID="cmPodatkowaStawka" runat="server"></ea:GridColumn>
<ea:GridColumn Width="7" Align="Center" DataMember="Bilansowa.Wspolczynnik" Caption="Wsp. (B)" runat="server"></ea:GridColumn>
<ea:GridColumn Width="7" Align="Center" DataMember="Podatkowa.Wspolczynnik" Caption="Wsp. (p)" ID="cmPodatkowaWspolczynnik" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Workers.WartosciSrodka.Wartosc01Bilansowa.Value" Total="Sum" Caption="Wartość na 01.01.br (B)" Format="{0:n}" ID="colWartosc01B" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Workers.WartosciSrodka.Wartosc01Podatkowa.Value" Total="Sum" Caption="Wartość na 01.01.br (P)" Format="{0:n}" ID="colWartosc01P" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Workers.WartosciSrodka.Odpisy01Bilansowe.Value" Total="Sum" Caption="Umorzenie na 01.01.br (B)" Format="{0:n}" ID="colOdpisy01B" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Workers.WartosciSrodka.Odpisy01PodatkoweZUlgami" Total="Sum" Caption="Umorzenie na 01.01.br (P)" Format="{0:n}" ID="colOdpisy01P" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" Total="Sum" Caption="Zwiększenia (B)" Format="{0:n}" ID="colZwWartosciB" runat="server" DataMember="Workers.WartosciSrodka.WartoscBilansowaZwiekszeniaBiezace"></ea:GridColumn>
<ea:GridColumn Align="Right" Total="Sum" Caption="Zwiększenia (P)" Format="{0:n}" ID="colZwWartosciP" runat="server" DataMember="Workers.WartosciSrodka.WartoscPodatkowaZwiekszeniaBiezace"></ea:GridColumn>
<ea:GridColumn Align="Right" Total="Sum" Caption="Umorzenia bieżące (B)" Format="{0:n}" ID="colZwOdpisowB" runat="server" DataMember="Workers.WartosciSrodka.OdpisyBilansoweZwiekszeniaBiezace"></ea:GridColumn>
<ea:GridColumn Align="Right" Total="Sum" Caption="Umorzenia bieżące (P)" Format="{0:n}" ID="colZwOdpisowP" runat="server" DataMember="Workers.WartosciSrodka.OdpisyPodatkoweZwiekszeniaZUlgamiBiezace"></ea:GridColumn>
<ea:GridColumn Align="Right" Total="Sum" Caption="Zmniejszenia (B)" Format="{0:n}" ID="colZmWartosciB" runat="server" DataMember="Workers.WartosciSrodka.WartoscBilansowaZmniejszeniaBiezace"></ea:GridColumn>
<ea:GridColumn Align="Right" Total="Sum" Caption="Zmniejszenia (P)" Format="{0:n}" ID="colZmWartosciP" runat="server" DataMember="Workers.WartosciSrodka.WartoscPodatkowaZmniejszeniaBiezace"></ea:GridColumn>
<ea:GridColumn Align="Right" Total="Sum" Caption="Korekty umorzeń (B)" Format="{0:n}" ID="colZmOdpisowB" runat="server" DataMember="Workers.WartosciSrodka.OdpisyBilansoweZmniejszeniaBiezace"></ea:GridColumn>
<ea:GridColumn Align="Right" Total="Sum" Caption="Korekty umorzeń (P)" Format="{0:n}" ID="colZmOdpisowP" runat="server" DataMember="Workers.WartosciSrodka.OdpisyPodatkoweZmniejszeniaBiezace"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Workers.WartosciSrodka.WartoscBilansowa.Value" Total="Sum" Caption="Wartość (B)" Format="{0:n}" ID="colWartoscB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Workers.WartosciSrodka.WartoscPodatkowa.Value" Total="Sum" Caption="Wartość (P)" Format="{0:n}" ID="colWartoscP" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Workers.WartosciSrodka.OdpisyBilansowe.Value" Total="Sum" Caption="Umorzenie (B)" Format="{0:n}" ID="colOdpisyB" runat="server"></ea:GridColumn>
<ea:GridColumn Align="Right" DataMember="Workers.WartosciSrodka.OdpisyPodatkoweZUlgami" Total="Sum" Caption="Umorzenie (P)" Format="{0:n}" ID="colOdpisyP" runat="server"></ea:GridColumn>
</Columns>
			</ea:Grid><BR>
			<cc1:ReportFooter id="ReportFooter1" runat="server"></cc1:ReportFooter>
		</form>
	</body>
</HTML>

